#!/usr/bin/python3
"""Upotreba ./validate.py test/*.in*"""

import string


def check(lines):
	nl = []   # ispravno formatirane linije

	n = int(lines[0])
	assert 1 <= n <= 100000, "n kriv"
	nl.append("{}\n".format(n))

	niz1 = list(map(int, lines[1].strip().split()))
	niz2 = list(map(int, lines[2].strip().split()))

	assert len(niz1) == n, "len niz1 kriv"
	assert len(niz2) == n, "len niz2 kriv"

	nl.append(("{}" + " {}"*(n-1) + "\n").format(*niz1))
	nl.append(("{}" + " {}"*(n-1) + "\n").format(*niz2))

	cnt = []
	for i in range(100005):
		cnt.append(0)

	for x in niz1:
		cnt[x] += 1
		assert 1 <= x <= 100000, "broj u niz1 nije u ogr"
	
	for x in niz2:
		cnt[x] += 1
		assert 1 <= x <= 100000, "broj u niz2 nije u ogr"
	
	for x in cnt:
		assert x % 2 == 0, "nema rjesenja!"
	
	assert lines == nl, "Krivi format (%s vs %s)" % (lines, nl)
	assert lines[-1][-1] == "\n", "Zadnji red ne zavrsava sa \\n"
	samo_dva = 0
	if cnt[1] + cnt[2] == 2 * n: samo_dva = 1
	return n, samo_dva

# Ocekivani clusteri! Ovo vjerojatno zelis promijeniti!
expected_clusters = {'prvi': 3, 'drugi' : 10, 'treci' : 2, 'normalni' : 3}

def what_cluster(data):
	n, t = data
	if n <= 100 and t: return 'prvi'
	if n <= 100: return 'drugi'
	if n <= 100000 and t: return 'treci'
	return 'normalni'

################### Zadatak-specifican kod iznad ove linije #########################

import sys
import glob
import hashlib


def group_in_batches(files):
	# mnozenje.in.1a, mnozenje.in.1b sprema u isti batch

	files.sort()
	B = []
	for f in files:
		if f[-1].islower() and len(B) > 0 and f[:-1] == B[-1][-1][:-1]:
			B[-1].append(f)
		else:
			B.append([f])
	return B


if __name__ == "__main__":
	f = []
	for pattern in sys.argv[1:]:
		for filename in glob.glob(pattern):
			f.append(filename)

	bc = []
	for batch in group_in_batches(f):
		if 'dummy' not in batch[0]:
			bc.append([])
			for filename in batch:
				print("{}: ".format(filename), end="")
				try:
					lines = open(filename).readlines()
					summary = check(lines)
					c = what_cluster(summary)
					if 'dummy' not in batch[0]:
						bc[-1].append(c)
				except Exception as e:
					print("Greska!", e)
					raise
				else:
					print("Sve ok! (cluster {}, summary = {})".format(c, summary))
	clusters = {}
	for b in bc:
		for c in b:
			assert c == b[0], "Ima razlicitih cluster-a unutar batcha"
		if not b[0] in clusters:
			clusters[b[0]] = 0
		clusters[b[0]] += 1

	assert clusters == expected_clusters, "Kriva raspodjela clustera ({} vs {})".format(clusters, expected_clusters)

	# Buda test - provjeri duplikate
	hashes = set(hashlib.sha1(open(x, 'rb').read()).hexdigest() for x in f)
	assert len(hashes) == len(f), "Ima duplikata!"
